string GetDescription()
{
	return "Drums - generates a randomized drum pattern in a latin style";
}

int GetVel(Time t)
{
	return RndInt(110,126);
}

void RealizePattern(RenderPart @p, double len, double[] pat, int pitch, int vel_off)
{
	for (int i = p.GetStartBar(); i < p.GetEndBar(); i++)
	{
		for (double m = 0; m < p.GetUniquePart().GetMetrum(); m+=len)
		{
			for (int n = 0; n < pat.length(); n++)
			{
				if (pat[n] + m < p.GetUniquePart().GetMetrum())
				{
					p.AddPercNote( CreateTime(i, m+pat[n]), CreateTime(i, m+pat[n]+0.125), pitch, RndInt(100,120)+vel_off);
				}	
			}
		}
	}	
}

void SpeedUpPattern(double[] @pat)
{
	for (int i = 0; i < pat.length(); i++)
	{
		pat[i] /= 2.0;	
	}	
}

void Render(RenderPart @p)
{
	double pattern_length = 4;
	double[] foot_pattern = { 0, 1.5, 2.0, 3.5 };
	double[] stick_pattern = { 0, 1,2.5,3.5 };
	double[] shaker1_pattern = {0.5, 1.5, 2.5, 3.5 };
	double[] shaker2_pattern = {1, 3 };
	double[] bebenek1_pattern = {0};
	double[] bebenek2_pattern = {0.5};
	
	double shaker3_length = 0.5;
	double bebenek_length = 1.0;
	
	if (RndInt(0,2) == 0) shaker3_length = 1.0;
	
	double[] shaker3_pattern = { 0 };
	
	if (p.GetTempo() < 80)
	{
		pattern_length /= 2;
		shaker3_length /= 2;
		bebenek_length /= 2;
		
		SpeedUpPattern(foot_pattern);
		SpeedUpPattern(stick_pattern);
		SpeedUpPattern(shaker1_pattern);
		SpeedUpPattern(shaker2_pattern);
		SpeedUpPattern(shaker3_pattern);
		SpeedUpPattern(bebenek1_pattern);
		SpeedUpPattern(bebenek2_pattern);
	}
		
	RealizePattern(p, pattern_length, foot_pattern, RndInt(35,36),5);
	RealizePattern(p, pattern_length, stick_pattern, 37,5);
	
	RealizePattern(p, pattern_length, shaker1_pattern, 36+33,0);
	RealizePattern(p, pattern_length, shaker2_pattern, 36+33+13, -25);
	
	if (RndInt(0,1) == 0) RealizePattern(p, shaker3_length, shaker3_pattern, 36+6, -30);
	else RealizePattern(p, shaker3_length, shaker3_pattern, 36+18, -30);
	
	if (RndInt(0,1) == 0)
	{
		RealizePattern(p, bebenek_length, bebenek1_pattern, 36+28,-5);
		RealizePattern(p, bebenek_length, bebenek2_pattern, 36+26,-6);
	}
}